import { z } from 'zod';
import { type APIClient } from '../api';
export declare const ProjectHostnameGetRequestSchema: z.ZodObject<{
    projectId: z.ZodString;
}, z.core.$strip>;
declare const HostnameGetDataSchema: z.ZodObject<{
    hostname: z.ZodNullable<z.ZodString>;
    url: z.ZodNullable<z.ZodString>;
}, z.core.$strip>;
type ProjectHostnameGetRequest = z.infer<typeof ProjectHostnameGetRequestSchema>;
export type ProjectHostnameGetResult = z.infer<typeof HostnameGetDataSchema>;
export declare function projectHostnameGet(client: APIClient, request: ProjectHostnameGetRequest): Promise<ProjectHostnameGetResult>;
export declare const ProjectHostnameSetRequestSchema: z.ZodObject<{
    projectId: z.ZodString;
    hostname: z.ZodString;
}, z.core.$strip>;
declare const HostnameSetDataSchema: z.ZodObject<{
    hostname: z.ZodString;
    url: z.ZodString;
}, z.core.$strip>;
type ProjectHostnameSetRequest = z.infer<typeof ProjectHostnameSetRequestSchema>;
export type ProjectHostnameSetResult = z.infer<typeof HostnameSetDataSchema>;
export declare function projectHostnameSet(client: APIClient, request: ProjectHostnameSetRequest): Promise<ProjectHostnameSetResult>;
export {};
//# sourceMappingURL=hostname.d.ts.map