import type { SortDirection } from '@agentuity/core';
import { z } from 'zod';
import { APIClient } from '../api';
export declare const OrgS3Resource: z.ZodObject<{
    bucket_name: z.ZodString;
    access_key: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    secret_key: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    region: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    endpoint: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    cloud_region: z.ZodString;
    org_id: z.ZodString;
    org_name: z.ZodString;
    bucket_type: z.ZodString;
    internal: z.ZodBoolean;
    description: z.ZodOptional<z.ZodNullable<z.ZodString>>;
}, z.core.$strip>;
export declare const OrgDBResource: z.ZodObject<{
    name: z.ZodString;
    description: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    username: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    password: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    cloud_region: z.ZodString;
    org_id: z.ZodString;
    org_name: z.ZodString;
    internal: z.ZodBoolean;
}, z.core.$strip>;
export declare const OrgResourceListResponse: z.ZodObject<{
    s3: z.ZodArray<z.ZodObject<{
        bucket_name: z.ZodString;
        access_key: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        secret_key: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        region: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        endpoint: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        cloud_region: z.ZodString;
        org_id: z.ZodString;
        org_name: z.ZodString;
        bucket_type: z.ZodString;
        internal: z.ZodBoolean;
        description: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    }, z.core.$strip>>;
    db: z.ZodArray<z.ZodObject<{
        name: z.ZodString;
        description: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        username: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        password: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        cloud_region: z.ZodString;
        org_id: z.ZodString;
        org_name: z.ZodString;
        internal: z.ZodBoolean;
    }, z.core.$strip>>;
}, z.core.$strip>;
export declare const OrgResourceListResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodObject<{
        s3: z.ZodArray<z.ZodObject<{
            bucket_name: z.ZodString;
            access_key: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            secret_key: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            region: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            endpoint: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            cloud_region: z.ZodString;
            org_id: z.ZodString;
            org_name: z.ZodString;
            bucket_type: z.ZodString;
            internal: z.ZodBoolean;
            description: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, z.core.$strip>>;
        db: z.ZodArray<z.ZodObject<{
            name: z.ZodString;
            description: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            username: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            password: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            url: z.ZodOptional<z.ZodNullable<z.ZodString>>;
            cloud_region: z.ZodString;
            org_id: z.ZodString;
            org_name: z.ZodString;
            internal: z.ZodBoolean;
        }, z.core.$strip>>;
    }, z.core.$strip>;
}, z.core.$strip>], "success">;
export type OrgResourceListResponse = z.infer<typeof OrgResourceListResponseSchema>;
export type OrgResourceList = z.infer<typeof OrgResourceListResponse>;
export type OrgS3Resource = z.infer<typeof OrgS3Resource>;
export type OrgDBResource = z.infer<typeof OrgDBResource>;
export type ResourceSortField = 'name' | 'created' | 'region';
export interface ListOrgResourcesOptions {
    /** Filter by resource type (default: "all") */
    type?: 'all' | 's3' | 'db';
    /** Filter by resource name substring */
    name?: string;
    /** Organization ID (required for CLI auth, extracted from context for SDK auth) */
    orgId?: string;
    /** Maximum number of resources to return */
    limit?: number;
    /** Number of resources to skip for pagination */
    offset?: number;
    /** Field to sort by */
    sort?: ResourceSortField;
    /** Sort direction (default: 'desc') */
    direction?: SortDirection;
}
/**
 * List all resources for the authenticated organization (across all regions)
 *
 * @param client - Catalyst API client (must be authenticated)
 * @param options - Optional filters including orgId for CLI auth
 * @returns List of S3 and DB resources with their cloud regions
 *
 * @example
 * // Get all resources (SDK auth - orgId from context)
 * const all = await listOrgResources(client);
 *
 * @example
 * // Get all resources (CLI auth - orgId required)
 * const all = await listOrgResources(client, { orgId: 'org_123' });
 *
 * @example
 * // Get only S3 buckets
 * const s3Only = await listOrgResources(client, { type: 's3', orgId: 'org_123' });
 *
 * @example
 * // Get only DBs
 * const dbsOnly = await listOrgResources(client, { type: 'db', orgId: 'org_123' });
 */
export declare function listOrgResources(client: APIClient, options?: ListOrgResourcesOptions): Promise<OrgResourceList>;
//# sourceMappingURL=resources.d.ts.map