/**
 * Reference to the original fetch function before instrumentation
 */
export declare const __originalFetch: typeof fetch;
/**
 * Instruments the global fetch function with OpenTelemetry tracing
 *
 * Replaces the global fetch with an instrumented version that creates spans
 * for each HTTP request and propagates trace context in headers
 */
export declare function instrumentFetch(): void;
//# sourceMappingURL=fetch.d.ts.map