export type BackgroundTaskStatus = 'pending' | 'running' | 'completed' | 'error' | 'cancelled';
export interface TaskProgress {
    toolCalls: number;
    lastTool?: string;
    lastUpdate: Date;
    lastMessage?: string;
    lastMessageAt?: Date;
}
export interface BackgroundTask {
    id: string;
    sessionId?: string;
    parentSessionId: string;
    parentMessageId?: string;
    description: string;
    prompt: string;
    agent: string;
    status: BackgroundTaskStatus;
    queuedAt?: Date;
    startedAt?: Date;
    completedAt?: Date;
    result?: string;
    error?: string;
    progress?: TaskProgress;
    concurrencyKey?: string;
    concurrencyGroup?: string;
    notifiedStatuses?: Set<BackgroundTaskStatus>;
}
export interface LaunchInput {
    description: string;
    prompt: string;
    agent: string;
    parentSessionId: string;
    parentMessageId?: string;
}
export interface ResumeInput {
    sessionId: string;
    prompt: string;
    parentSessionId: string;
    parentMessageId?: string;
}
export interface BackgroundTaskConfig {
    enabled: boolean;
    defaultConcurrency: number;
    staleTimeoutMs: number;
    providerConcurrency?: Record<string, number>;
    modelConcurrency?: Record<string, number>;
}
/**
 * Result of inspecting a background task's session.
 * Provides access to session details and messages for debugging.
 */
export interface TaskInspection {
    taskId: string;
    sessionId: string;
    status: BackgroundTaskStatus;
    /** Session details from OpenCode SDK */
    session: unknown;
    /** Messages from the session */
    messages: Array<{
        info: unknown;
        parts: unknown[];
    }>;
    /** Last activity timestamp from task progress */
    lastActivity?: string;
}
//# sourceMappingURL=types.d.ts.map