/**
 * File Watcher for Dev Server Hot Reload
 *
 * Watches source files and triggers server restart on changes.
 * Handles both backend (API, agents, lib) and generates restart signals.
 */
import type { Logger } from '../../types';
export interface FileWatcherOptions {
    rootDir: string;
    logger: Logger;
    onRestart: () => void;
    additionalPaths?: string[];
}
export interface FileWatcherManager {
    start: () => void;
    stop: () => void;
    pause: () => void;
    resume: () => void;
}
/**
 * Create a file watcher manager for hot reload
 */
export declare function createFileWatcher(options: FileWatcherOptions): FileWatcherManager;
//# sourceMappingURL=file-watcher.d.ts.map