import { z } from 'zod';
import { APIResponseSchema } from '../api';
import { ThreadSchema } from './list';
import { ThreadResponseError } from './util';
export const _ThreadGetRequestSchema = z.object({
    id: z.string().describe('the thread id'),
});
export const ThreadGetResponseSchema = APIResponseSchema(ThreadSchema);
/**
 * Get a single thread by id
 *
 * @param client
 * @param request
 * @returns
 */
export async function threadGet(client, request) {
    const resp = await client.request('GET', `/thread/2025-03-17/${request.id}`, ThreadGetResponseSchema);
    if (resp.success) {
        return resp.data;
    }
    throw new ThreadResponseError({ message: resp.message });
}
//# sourceMappingURL=get.js.map