import type { ExecutionStatus } from '@agentuity/core';
import { z } from 'zod';
import { type APIClient } from '../api';
export declare const ExecutionInfoSchema: z.ZodObject<{
    executionId: z.ZodString;
    sandboxId: z.ZodString;
    type: z.ZodOptional<z.ZodString>;
    status: z.ZodEnum<{
        failed: "failed";
        completed: "completed";
        timeout: "timeout";
        running: "running";
        queued: "queued";
        cancelled: "cancelled";
    }>;
    command: z.ZodOptional<z.ZodArray<z.ZodString>>;
    exitCode: z.ZodOptional<z.ZodNumber>;
    durationMs: z.ZodOptional<z.ZodNumber>;
    startedAt: z.ZodOptional<z.ZodString>;
    completedAt: z.ZodOptional<z.ZodString>;
    error: z.ZodOptional<z.ZodString>;
    stdoutStreamUrl: z.ZodOptional<z.ZodString>;
    stderrStreamUrl: z.ZodOptional<z.ZodString>;
}, z.core.$strip>;
export declare const ExecutionGetResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodObject<{
        executionId: z.ZodString;
        sandboxId: z.ZodString;
        type: z.ZodOptional<z.ZodString>;
        status: z.ZodEnum<{
            failed: "failed";
            completed: "completed";
            timeout: "timeout";
            running: "running";
            queued: "queued";
            cancelled: "cancelled";
        }>;
        command: z.ZodOptional<z.ZodArray<z.ZodString>>;
        exitCode: z.ZodOptional<z.ZodNumber>;
        durationMs: z.ZodOptional<z.ZodNumber>;
        startedAt: z.ZodOptional<z.ZodString>;
        completedAt: z.ZodOptional<z.ZodString>;
        error: z.ZodOptional<z.ZodString>;
        stdoutStreamUrl: z.ZodOptional<z.ZodString>;
        stderrStreamUrl: z.ZodOptional<z.ZodString>;
    }, z.core.$strip>;
}, z.core.$strip>], "success">;
export declare const ExecutionListDataSchema: z.ZodObject<{
    executions: z.ZodArray<z.ZodObject<{
        executionId: z.ZodString;
        sandboxId: z.ZodString;
        type: z.ZodOptional<z.ZodString>;
        status: z.ZodEnum<{
            failed: "failed";
            completed: "completed";
            timeout: "timeout";
            running: "running";
            queued: "queued";
            cancelled: "cancelled";
        }>;
        command: z.ZodOptional<z.ZodArray<z.ZodString>>;
        exitCode: z.ZodOptional<z.ZodNumber>;
        durationMs: z.ZodOptional<z.ZodNumber>;
        startedAt: z.ZodOptional<z.ZodString>;
        completedAt: z.ZodOptional<z.ZodString>;
        error: z.ZodOptional<z.ZodString>;
        stdoutStreamUrl: z.ZodOptional<z.ZodString>;
        stderrStreamUrl: z.ZodOptional<z.ZodString>;
    }, z.core.$strip>>;
}, z.core.$strip>;
export declare const ExecutionListResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodObject<{
        executions: z.ZodArray<z.ZodObject<{
            executionId: z.ZodString;
            sandboxId: z.ZodString;
            type: z.ZodOptional<z.ZodString>;
            status: z.ZodEnum<{
                failed: "failed";
                completed: "completed";
                timeout: "timeout";
                running: "running";
                queued: "queued";
                cancelled: "cancelled";
            }>;
            command: z.ZodOptional<z.ZodArray<z.ZodString>>;
            exitCode: z.ZodOptional<z.ZodNumber>;
            durationMs: z.ZodOptional<z.ZodNumber>;
            startedAt: z.ZodOptional<z.ZodString>;
            completedAt: z.ZodOptional<z.ZodString>;
            error: z.ZodOptional<z.ZodString>;
            stdoutStreamUrl: z.ZodOptional<z.ZodString>;
            stderrStreamUrl: z.ZodOptional<z.ZodString>;
        }, z.core.$strip>>;
    }, z.core.$strip>;
}, z.core.$strip>], "success">;
export interface ExecutionInfo {
    executionId: string;
    sandboxId: string;
    type?: string;
    status: ExecutionStatus;
    command?: string[];
    exitCode?: number;
    durationMs?: number;
    startedAt?: string;
    completedAt?: string;
    error?: string;
    stdoutStreamUrl?: string;
    stderrStreamUrl?: string;
}
export interface ExecutionGetParams {
    executionId: string;
    orgId?: string;
    /**
     * Optional wait duration for long-polling. If specified, the server will hold
     * the connection open until the execution reaches a terminal state (completed,
     * failed, timeout, cancelled) or the wait duration expires.
     *
     * Format: duration string like "30s", "1m", "5m"
     * Maximum: 5 minutes (server will cap at this value)
     *
     * If not specified, returns immediately with current status.
     */
    wait?: string;
}
/**
 * Retrieves detailed information about a specific execution.
 *
 * @param client - The API client to use for the request
 * @param params - Parameters including the execution ID and optional wait duration
 * @returns Detailed execution information including status, timing, and errors
 * @throws {SandboxResponseError} If the execution is not found or request fails
 *
 * @example
 * // Immediate return (current behavior)
 * const info = await executionGet(client, { executionId: 'exec_123' });
 *
 * @example
 * // Long-poll: wait up to 60 seconds for completion
 * const info = await executionGet(client, { executionId: 'exec_123', wait: '60s' });
 */
export declare function executionGet(client: APIClient, params: ExecutionGetParams): Promise<ExecutionInfo>;
export interface ExecutionListParams {
    sandboxId: string;
    orgId?: string;
    limit?: number;
}
export interface ExecutionListResponse {
    executions: ExecutionInfo[];
}
/**
 * Lists all executions for a specific sandbox.
 *
 * @param client - The API client to use for the request
 * @param params - Parameters including the sandbox ID and optional limit
 * @returns List of execution information for the sandbox
 * @throws {SandboxResponseError} If the sandbox is not found or request fails
 */
export declare function executionList(client: APIClient, params: ExecutionListParams): Promise<ExecutionListResponse>;
//# sourceMappingURL=execution.d.ts.map