import { z } from 'zod';
import { APIClient } from '../api';
export declare const APIKeyDeleteResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodNumber;
}, z.core.$strip>], "success">;
/**
 * Delete an API key (soft delete)
 *
 * @param client
 * @param id the API key id to delete
 * @returns number of rows affected
 */
export declare function apikeyDelete(client: APIClient, id: string): Promise<number>;
//# sourceMappingURL=delete.d.ts.map