import type { DBMessage, DBSession, DBTextPart, DBTodo, DBToolCall, OpenCodeDBConfig, SessionCostSummary, SessionStatus, SessionTreeNode } from './types';
export declare class OpenCodeDBReader {
    private db;
    private available;
    private readonly config;
    private dbPath;
    private statements;
    constructor(config?: OpenCodeDBConfig);
    isAvailable(): boolean;
    open(): boolean;
    close(): void;
    getSession(id: string): DBSession | null;
    getChildSessions(parentId: string): DBSession[];
    getSessionsByProject(projectId: string): DBSession[];
    getSessionTree(rootId: string): SessionTreeNode;
    getMessages(sessionId: string, opts?: {
        limit?: number;
        offset?: number;
    }): DBMessage[];
    getLatestMessage(sessionId: string): DBMessage | null;
    getMessageCount(sessionId: string): number;
    getActiveToolCalls(sessionId: string): DBToolCall[];
    getToolCallHistory(sessionId: string, opts?: {
        limit?: number;
    }): DBToolCall[];
    getTextParts(sessionId: string, opts?: {
        limit?: number;
    }): DBTextPart[];
    getTodos(sessionId: string): DBTodo[];
    getSessionCost(sessionId: string): SessionCostSummary;
    getSessionStatus(sessionId: string): SessionStatus;
    searchSessions(query: string, opts?: {
        limit?: number;
    }): DBSession[];
    getSessionDashboard(parentSessionId: string): {
        sessions: SessionTreeNode[];
        totalCost: number;
    };
    private ensureOpen;
    private getStatement;
    private validateSchema;
    private buildSessionTree;
}
//# sourceMappingURL=reader.d.ts.map