import { z } from 'zod';
export declare const SessionStartEventSchema: z.ZodObject<{
    id: z.ZodString;
    threadId: z.ZodOptional<z.ZodString>;
    orgId: z.ZodString;
    projectId: z.ZodString;
    deploymentId: z.ZodOptional<z.ZodString>;
    routeId: z.ZodString;
    environment: z.ZodString;
    devmode: z.ZodBoolean;
    url: z.ZodString;
    method: z.ZodString;
    trigger: z.ZodEnum<{
        agent: "agent";
        api: "api";
        email: "email";
        sms: "sms";
        cron: "cron";
        manual: "manual";
        discord: "discord";
        websocket: "websocket";
    }>;
    metadata: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, z.core.$strip>;
export type SessionStartEvent = z.infer<typeof SessionStartEventSchema>;
export declare const SessionCompleteEventSchema: z.ZodObject<{
    id: z.ZodString;
    threadId: z.ZodNullable<z.ZodString>;
    error: z.ZodOptional<z.ZodString>;
    agentIds: z.ZodOptional<z.ZodArray<z.ZodString>>;
    statusCode: z.ZodNumber;
    userData: z.ZodOptional<z.ZodString>;
    metadata: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, z.core.$strip>;
export type SessionCompleteEvent = z.infer<typeof SessionCompleteEventSchema>;
export declare const SessionStartEventDelayedSchema: z.ZodIntersection<z.ZodObject<{
    id: z.ZodString;
    threadId: z.ZodOptional<z.ZodString>;
    orgId: z.ZodString;
    projectId: z.ZodString;
    deploymentId: z.ZodOptional<z.ZodString>;
    routeId: z.ZodString;
    environment: z.ZodString;
    devmode: z.ZodBoolean;
    url: z.ZodString;
    method: z.ZodString;
    trigger: z.ZodEnum<{
        agent: "agent";
        api: "api";
        email: "email";
        sms: "sms";
        cron: "cron";
        manual: "manual";
        discord: "discord";
        websocket: "websocket";
    }>;
    metadata: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, z.core.$strip>, z.ZodObject<{
    timestamp: z.ZodNumber;
}, z.core.$strip>>;
export declare const SessionCompleteEventDelayedSchema: z.ZodIntersection<z.ZodObject<{
    id: z.ZodString;
    threadId: z.ZodNullable<z.ZodString>;
    error: z.ZodOptional<z.ZodString>;
    agentIds: z.ZodOptional<z.ZodArray<z.ZodString>>;
    statusCode: z.ZodNumber;
    userData: z.ZodOptional<z.ZodString>;
    metadata: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, z.core.$strip>, z.ZodObject<{
    timestamp: z.ZodNumber;
}, z.core.$strip>>;
/**
 * SessionEventProvider is a provider for logging and tracking agent session lifecycle events.
 * Sessions represent individual agent executions triggered by API calls, cron jobs, or other sources.
 */
export interface SessionEventProvider {
    /**
     * Called when an agent session starts. Records the initial context and metadata
     * for the session including trigger source, environment, and routing information.
     *
     * @param event - SessionStartEvent containing session initialization data
     *
     * @example
     * ```typescript
     * await sessionProvider.start({
     *   id: 'session-123',
     *   threadId: 'thread-abc',
     *   orgId: 'org-456',
     *   projectId: 'proj-789',
     *   deploymentId: 'deploy-xyz',
     *   routeId: 'route-001',
     *   environment: 'production',
     *   devmode: false,
     *   url: '/api/agent/chat',
     *   method: 'POST',
     *   trigger: 'api'
     * });
     * ```
     */
    start(event: SessionStartEvent): Promise<void>;
    /**
     * Called when an agent session completes (successfully or with error).
     * Records final status, any errors, and which agents participated.
     *
     * @param event - SessionCompleteEvent containing completion status and results
     *
     * @example
     * ```typescript
     * // Successful completion
     * await sessionProvider.complete({
     *   id: 'session-123',
     *   statusCode: 200,
     *   agentIds: ['agent-1', 'agent-2']
     * });
     *
     * // Completion with error
     * await sessionProvider.complete({
     *   id: 'session-123',
     *   statusCode: 500,
     *   error: 'Database connection timeout',
     *   agentIds: ['agent-1']
     * });
     * ```
     */
    complete(event: SessionCompleteEvent): Promise<void>;
}
//# sourceMappingURL=session.d.ts.map