import type { BuildMetadata } from '../../types';
import { type WorkbenchConfig } from '@agentuity/core';
export declare function getDevmodeDeploymentId(projectId: string, endpointId: string): string;
export declare function parseEvalMetadata(rootDir: string, filename: string, contents: string, projectId: string, deploymentId: string, agentId?: string, agentMetadata?: Map<string, Map<string, string>>): Promise<[
    string,
    Array<{
        filename: string;
        id: string;
        version: string;
        name: string;
        evalId: string;
        description?: string;
    }>
]>;
export declare function parseAgentMetadata(rootDir: string, filename: string, contents: string, projectId: string, deploymentId: string): Promise<[string, Map<string, string>] | undefined>;
export declare function parseRoute(rootDir: string, filename: string, projectId: string, deploymentId: string, visitedFiles?: Set<string>, mountedSubrouters?: Set<string>): Promise<BuildMetadata['routes']>;
/**
 * Result of workbench analysis
 */
export interface WorkbenchAnalysis {
    hasWorkbench: boolean;
    config: WorkbenchConfig | null;
}
/**
 * Check if a TypeScript file actively uses a specific function
 * (ignores comments and unused imports)
 *
 * @param content - The TypeScript source code
 * @param functionName - The function name to check for (e.g., 'createWorkbench')
 * @returns true if the function is both imported and called
 */
export declare function checkFunctionUsage(content: string, functionName: string): boolean;
/**
 * Check if app.ts contains conflicting routes for a given endpoint
 */
export declare function checkRouteConflicts(content: string, workbenchEndpoint: string): boolean;
/**
 * Extract AppState type from setup() return value in createApp call
 *
 * @param content - The TypeScript source code from app.ts
 * @returns Type definition string or null if no setup found
 */
export declare function extractAppStateType(content: string): string | null;
/**
 * Generate lifecycle type files (src/generated/state.ts and src/generated/router.ts)
 *
 * @param rootDir - Root directory of the project
 * @param outDir - Output directory (typically src/generated/)
 * @param appFilePath - Path to app.ts file
 * @returns true if files were generated, false if no setup found
 */
export declare function generateLifecycleTypes(rootDir: string, outDir: string, appFilePath: string): Promise<boolean>;
/**
 * Analyze workbench usage and extract configuration
 *
 * @param content - The TypeScript source code
 * @returns workbench analysis including usage and config
 */
export declare function analyzeWorkbench(content: string): WorkbenchAnalysis;
/**
 * Find the end position of createApp call statement in the source code
 * Uses AST parsing to reliably find the complete statement including await/const assignment
 *
 * @param content - The source code content
 * @returns The character position after the createApp statement, or -1 if not found
 */
export declare function findCreateAppEndPosition(content: string): number;
//# sourceMappingURL=ast.d.ts.map