import type { PluginInput } from '@opencode-ai/plugin';
import type { BackgroundTask, BackgroundTaskConfig, LaunchInput } from './types';
type EventPayload = {
    type: string;
    properties?: Record<string, unknown>;
};
export interface BackgroundManagerCallbacks {
    onSubagentSessionCreated?: (event: {
        sessionId: string;
        parentId: string;
        title: string;
    }) => void;
    onSubagentSessionDeleted?: (event: {
        sessionId: string;
    }) => void;
    onShutdown?: () => void | Promise<void>;
}
export declare class BackgroundManager {
    private ctx;
    private config;
    private concurrency;
    private callbacks?;
    private tasks;
    private tasksByParent;
    private tasksBySession;
    private notifications;
    private toolCallIds;
    private shuttingDown;
    constructor(ctx: PluginInput, config?: BackgroundTaskConfig, callbacks?: BackgroundManagerCallbacks);
    launch(input: LaunchInput): Promise<BackgroundTask>;
    getTask(id: string): BackgroundTask | undefined;
    getTasksByParent(sessionId: string): BackgroundTask[];
    findBySession(sessionId: string): BackgroundTask | undefined;
    cancel(taskId: string): boolean;
    handleEvent(event: EventPayload): void;
    markForNotification(task: BackgroundTask): void;
    getPendingNotifications(sessionId: string): BackgroundTask[];
    clearNotifications(sessionId: string): void;
    shutdown(): void;
    private indexTask;
    private startTask;
    private updateProgress;
    private createProgress;
    private completeTask;
    private failTask;
    private releaseConcurrency;
    private notifyParent;
    private abortSession;
    private fetchLatestResult;
    private getConcurrencyGroup;
    private getConcurrencyKey;
    private expireStaleTasks;
}
export {};
//# sourceMappingURL=manager.d.ts.map