/**
 * @agentuity/drizzle - Drizzle ORM integration with resilient PostgreSQL connections
 *
 * This package provides a seamless integration between Drizzle ORM and
 * @agentuity/postgres, combining type-safe database queries with automatic
 * reconnection capabilities.
 *
 * @example
 * ```typescript
 * import { createPostgresDrizzle, pgTable, text, serial } from '@agentuity/drizzle';
 *
 * // Define your schema
 * const users = pgTable('users', {
 *   id: serial('id').primaryKey(),
 *   name: text('name').notNull(),
 *   email: text('email').notNull().unique(),
 * });
 *
 * // Create the database instance
 * const { db, close } = createPostgresDrizzle({
 *   schema: { users },
 * });
 *
 * // Execute type-safe queries
 * const allUsers = await db.select().from(users);
 *
 * // Clean up when done
 * await close();
 * ```
 *
 * @packageDocumentation
 */
export { createPostgresDrizzle } from './postgres';
export type { PostgresDrizzleConfig, PostgresDrizzle } from './types';
export { postgres, PostgresClient, type CallablePostgresClient, type PostgresConfig, type ReconnectConfig, type ConnectionStats, type TLSConfig, type TransactionOptions, type ReserveOptions, } from '@agentuity/postgres';
export { sql, eq, and, or, not, desc, asc, gt, gte, lt, lte, ne, isNull, isNotNull, inArray, notInArray, between, like, ilike, } from 'drizzle-orm';
export { pgTable, pgSchema, pgEnum, bigint, bigserial, boolean, char, cidr, customType, date, doublePrecision, inet, integer, interval, json, jsonb, macaddr, macaddr8, numeric, real, serial, smallint, smallserial, text, time, timestamp, uuid, varchar, primaryKey, foreignKey, unique, uniqueIndex, index, check, } from 'drizzle-orm/pg-core';
export { drizzleAdapter } from 'better-auth/adapters/drizzle';
//# sourceMappingURL=index.d.ts.map