import { z } from 'zod';
import { APIClient } from '../api';
declare const StreamInfoSchema: z.ZodObject<{
    id: z.ZodString;
    namespace: z.ZodString;
    metadata: z.ZodRecord<z.ZodString, z.ZodString>;
    url: z.ZodString;
    sizeBytes: z.ZodNumber;
    expiresAt: z.ZodNullable<z.ZodString>;
    orgId: z.ZodString;
    projectId: z.ZodNullable<z.ZodString>;
    projectName: z.ZodNullable<z.ZodString>;
}, z.core.$strip>;
declare const StreamListDataSchema: z.ZodObject<{
    streams: z.ZodArray<z.ZodObject<{
        id: z.ZodString;
        namespace: z.ZodString;
        metadata: z.ZodRecord<z.ZodString, z.ZodString>;
        url: z.ZodString;
        sizeBytes: z.ZodNumber;
        expiresAt: z.ZodNullable<z.ZodString>;
        orgId: z.ZodString;
        projectId: z.ZodNullable<z.ZodString>;
        projectName: z.ZodNullable<z.ZodString>;
    }, z.core.$strip>>;
    total: z.ZodNumber;
}, z.core.$strip>;
declare const StreamListResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodObject<{
        streams: z.ZodArray<z.ZodObject<{
            id: z.ZodString;
            namespace: z.ZodString;
            metadata: z.ZodRecord<z.ZodString, z.ZodString>;
            url: z.ZodString;
            sizeBytes: z.ZodNumber;
            expiresAt: z.ZodNullable<z.ZodString>;
            orgId: z.ZodString;
            projectId: z.ZodNullable<z.ZodString>;
            projectName: z.ZodNullable<z.ZodString>;
        }, z.core.$strip>>;
        total: z.ZodNumber;
    }, z.core.$strip>;
}, z.core.$strip>], "success">;
export type StreamListResponse = z.infer<typeof StreamListResponseSchema>;
export type StreamListData = z.infer<typeof StreamListDataSchema>;
export type StreamInfo = z.infer<typeof StreamInfoSchema>;
export interface StreamListOptions {
    /**
     * Filter by specific project ID
     */
    projectId?: string;
    /**
     * Filter by specific organization ID
     */
    orgId?: string;
    /**
     * Filter by stream namespace
     */
    namespace?: string;
    /**
     * Maximum number of streams to return (default: 100, max: 1000)
     */
    limit?: number;
    /**
     * Number of streams to skip for pagination
     */
    offset?: number;
    /**
     * Filter by metadata key-value pairs
     */
    metadata?: Record<string, string>;
}
/**
 * List streams with optional filtering.
 *
 * If no projectId or orgId is provided, returns streams from all orgs the user is a member of.
 *
 * @param client - The API client
 * @param options - Filtering and pagination options
 * @returns A promise that resolves to the list of streams with metadata
 *
 * @example
 * // List all streams across all orgs
 * const result = await streamList(client);
 * console.log(`Found ${result.total} streams`);
 *
 * @example
 * // List streams for a specific project
 * const result = await streamList(client, { projectId: 'proj_123' });
 *
 * @example
 * // List streams with namespace filter
 * const result = await streamList(client, { namespace: 'agent-logs' });
 *
 * @example
 * // List streams with metadata filter
 * const result = await streamList(client, {
 *   metadata: { type: 'export', env: 'production' }
 * });
 */
export declare function streamList(client: APIClient, options?: StreamListOptions): Promise<StreamListData>;
export {};
//# sourceMappingURL=list.d.ts.map