import { APIClient } from '../api';
import type { SandboxCreateOptions, SandboxStatus } from '@agentuity/core';
export interface SandboxCreateResponse {
    sandboxId: string;
    status: SandboxStatus;
    stdoutStreamId?: string;
    stdoutStreamUrl?: string;
    stderrStreamId?: string;
    stderrStreamUrl?: string;
}
export interface SandboxCreateParams {
    options?: SandboxCreateOptions;
    orgId?: string;
}
/**
 * Creates a new sandbox instance.
 *
 * @param client - The API client to use for the request
 * @param params - Parameters for creating the sandbox
 * @returns The created sandbox response including sandbox ID and stream URLs
 * @throws {SandboxResponseError} If the sandbox creation fails
 */
export declare function sandboxCreate(client: APIClient, params?: SandboxCreateParams): Promise<SandboxCreateResponse>;
//# sourceMappingURL=create.d.ts.map