import { z } from 'zod';
import { APIClient } from '../api';
declare const SandboxInfoSchema: z.ZodObject<{
    id: z.ZodString;
    name: z.ZodNullable<z.ZodString>;
    description: z.ZodNullable<z.ZodString>;
    status: z.ZodString;
    region: z.ZodNullable<z.ZodString>;
    createdAt: z.ZodNullable<z.ZodString>;
    orgId: z.ZodString;
    orgName: z.ZodNullable<z.ZodString>;
    projectId: z.ZodNullable<z.ZodString>;
}, z.core.$strip>;
declare const SandboxListDataSchema: z.ZodObject<{
    sandboxes: z.ZodArray<z.ZodObject<{
        id: z.ZodString;
        name: z.ZodNullable<z.ZodString>;
        description: z.ZodNullable<z.ZodString>;
        status: z.ZodString;
        region: z.ZodNullable<z.ZodString>;
        createdAt: z.ZodNullable<z.ZodString>;
        orgId: z.ZodString;
        orgName: z.ZodNullable<z.ZodString>;
        projectId: z.ZodNullable<z.ZodString>;
    }, z.core.$strip>>;
    total: z.ZodNumber;
}, z.core.$strip>;
declare const SandboxListResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodObject<{
        sandboxes: z.ZodArray<z.ZodObject<{
            id: z.ZodString;
            name: z.ZodNullable<z.ZodString>;
            description: z.ZodNullable<z.ZodString>;
            status: z.ZodString;
            region: z.ZodNullable<z.ZodString>;
            createdAt: z.ZodNullable<z.ZodString>;
            orgId: z.ZodString;
            orgName: z.ZodNullable<z.ZodString>;
            projectId: z.ZodNullable<z.ZodString>;
        }, z.core.$strip>>;
        total: z.ZodNumber;
    }, z.core.$strip>;
}, z.core.$strip>], "success">;
export type CLISandboxListResponse = z.infer<typeof SandboxListResponseSchema>;
export type CLISandboxListData = z.infer<typeof SandboxListDataSchema>;
export type CLISandboxInfo = z.infer<typeof SandboxInfoSchema>;
export interface CLISandboxListOptions {
    /**
     * Filter by specific project ID
     */
    projectId?: string;
    /**
     * Filter by specific organization ID
     */
    orgId?: string;
    /**
     * Filter by sandbox status
     */
    status?: 'creating' | 'idle' | 'running' | 'terminated' | 'failed';
    /**
     * Maximum number of sandboxes to return (default: 50, max: 100)
     */
    limit?: number;
    /**
     * Number of sandboxes to skip for pagination
     */
    offset?: number;
}
/**
 * List sandboxes with optional filtering using the CLI API endpoint.
 *
 * This endpoint searches across all organizations the user is a member of,
 * unlike the Catalyst API which requires an orgId.
 *
 * @param client - The API client
 * @param options - Filtering and pagination options
 * @returns A promise that resolves to the list of sandboxes
 *
 * @example
 * // List all sandboxes across all orgs
 * const result = await cliSandboxList(client);
 * console.log(`Found ${result.total} sandboxes`);
 *
 * @example
 * // List running sandboxes
 * const result = await cliSandboxList(client, { status: 'running' });
 *
 * @example
 * // List sandboxes for a specific project
 * const result = await cliSandboxList(client, { projectId: 'proj_123' });
 */
export declare function cliSandboxList(client: APIClient, options?: CLISandboxListOptions): Promise<CLISandboxListData>;
export {};
//# sourceMappingURL=cli-list.d.ts.map