import { z } from 'zod';
import { APIResponseSchema } from '../api';
import { ProjectResponseError } from './util';
const UpdateRegionRequestSchema = z.object({
    cloudRegion: z.string().describe('the cloud region to update the project to'),
});
const UpdateRegionResponseSchema = APIResponseSchema(z.object({
    id: z.string().describe('the project id'),
}));
/**
 * Update a project's cloud region
 *
 * @param client - The API client
 * @param projectId - The project id to update
 * @param region - The new cloud region
 * @returns The project id on success
 */
export async function projectUpdateRegion(client, projectId, region) {
    const resp = await client.request('PATCH', `/cli/project/${projectId}`, UpdateRegionResponseSchema, { cloudRegion: region }, UpdateRegionRequestSchema);
    if (resp.success) {
        return resp.data;
    }
    throw new ProjectResponseError({ message: resp.message ?? 'failed to update project region' });
}
//# sourceMappingURL=update-region.js.map