import { z } from 'zod';
import { APIClient } from '../api';
declare const _OrgEnvDeleteRequestSchema: z.ZodObject<{
    id: z.ZodString;
    env: z.ZodOptional<z.ZodArray<z.ZodString>>;
    secrets: z.ZodOptional<z.ZodArray<z.ZodString>>;
}, z.core.$strip>;
type OrgEnvDeleteRequest = z.infer<typeof _OrgEnvDeleteRequestSchema>;
/**
 * Delete environment variables and/or secrets from an organization.
 * Provide arrays of keys to delete.
 * Requires admin/owner role.
 */
export declare function orgEnvDelete(client: APIClient, request: OrgEnvDeleteRequest): Promise<void>;
export {};
//# sourceMappingURL=env-delete.d.ts.map