/**
 * Validates a value against a StandardSchema.
 *
 * @param schema - The StandardSchema to validate against
 * @param value - The value to validate
 * @returns ValidationResult with success/failure and data/issues
 */
export async function validateSchema(schema, value) {
    const result = await schema['~standard'].validate(value);
    if ('issues' in result && result.issues) {
        return { success: false, issues: Array.from(result.issues) };
    }
    return { success: true, data: result.value };
}
/**
 * Format validation issues into a readable error message.
 *
 * @param issues - Array of validation issues
 * @returns Formatted error message
 */
export function formatValidationIssues(issues) {
    return issues
        .map((issue) => {
        const path = issue.path?.map((p) => (typeof p === 'object' ? p.key : p)).join('.') || '';
        return path ? `${path}: ${issue.message}` : issue.message;
    })
        .join(', ');
}
//# sourceMappingURL=_validation.js.map