import { z } from 'zod';
export const AgentRoleSchema = z.enum([
    'lead',
    'scout',
    'builder',
    'architect',
    'reviewer',
    'memory',
    'expert',
    'runner',
    'reasoner',
    'product',
    'monitor',
]);
export const TaskStatusSchema = z.enum(['pending', 'running', 'completed', 'failed', 'cancelled']);
export const OrchestrationPatternSchema = z.enum(['single', 'fanout', 'pipeline']);
export const CadenceStatusSchema = z.enum([
    'running',
    'paused',
    'completed',
    'failed',
    'cancelled',
]);
export const CadenceSandboxModeSchema = z.enum(['off', 'per_iteration', 'persistent']);
/** Extended thinking configuration for Anthropic models */
export const ThinkingConfigSchema = z.object({
    type: z.enum(['enabled', 'disabled']),
    budgetTokens: z.number().optional(),
});
/** Reasoning effort for OpenAI models */
export const ReasoningEffortSchema = z.enum(['low', 'medium', 'high', 'xhigh']);
/** Model variant for Anthropic thinking levels */
export const ModelVariantSchema = z.enum(['low', 'medium', 'high', 'max']);
export const AgentModelConfigSchema = z.object({
    model: z.string().optional(),
    temperature: z.number().min(0).max(2).optional(),
    variant: ModelVariantSchema.optional(),
    reasoningEffort: ReasoningEffortSchema.optional(),
    thinking: ThinkingConfigSchema.optional(),
    maxSteps: z.number().optional(),
});
export const BackgroundTaskConfigSchema = z.object({
    enabled: z.boolean(),
    defaultConcurrency: z.number(),
    staleTimeoutMs: z.number(),
    providerConcurrency: z.record(z.string(), z.number()).optional(),
    modelConcurrency: z.record(z.string(), z.number()).optional(),
});
export const SkillsConfigSchema = z.object({
    enabled: z.boolean(),
    paths: z.array(z.string()).optional(),
    disabled: z.array(z.string()).optional(),
});
export const TmuxConfigSchema = z.object({
    enabled: z.boolean(),
    maxPanes: z.number(),
    mainPaneMinWidth: z.number(),
    agentPaneMinWidth: z.number(),
});
export const CoderConfigSchema = z.object({
    org: z.string().optional(),
    disabledMcps: z.array(z.string()).optional(),
    blockedCommands: z.array(z.string()).optional(),
    background: BackgroundTaskConfigSchema.optional(),
    skills: SkillsConfigSchema.optional(),
    tmux: TmuxConfigSchema.optional(),
});
// ToolDefinition is re-exported from @opencode-ai/plugin above
//# sourceMappingURL=types.js.map