import { type BaseEvalOptions } from './types';
export declare const politenessPrompt = "You are evaluating the politeness of an LLM response.\n\n## Inputs\n\n- USER REQUEST: {{USER_REQUEST}}\n- MODEL RESPONSE: {{MODEL_RESPONSE}}\n\n## Your task\n\n1. Assume a reasonable but socially sensitive end user reading the response.\n2. Read the MODEL RESPONSE literally, without assuming positive intent.\n3. Identify any language that could reasonably be perceived as rude, dismissive, condescending, sarcastic, hostile, or overly curt.\n\n## Score\n\n- Start from 1.0.\n- Subtract points for each issue:\n   - Mildly curt or cold phrasing: \u22120.2\n   - Dismissive or condescending phrasing: \u22120.4\n   - Hostile, sarcastic, or disrespectful phrasing: \u22120.6\n- Minimum score is 0.0.\n- Multiple violations compound independently.\n\n## Pass/Fail\n\n- passed = true only if score \u2265 0.8 AND no hostile or dismissive language is present.\n\n## Constraints\n\n- Do not infer intent beyond the text.\n- Do not excuse tone due to correctness or usefulness.\n- Do not normalize bluntness unless explicitly requested.\n\n## Output format (STRICT JSON, one line reason):\n\n{\n  \"score\": <number between 0.0 and 1.0>,\n  \"passed\": <true|false>,\n  \"reason\": \"<single concise sentence explaining the score>\"\n}";
type PolitenessEvalOptions = BaseEvalOptions & {
    threshold: number;
};
export declare const politeness: <TAgentInput extends import("@agentuity/core").StandardSchemaV1 | undefined = any, TAgentOutput extends import("@agentuity/core").StandardSchemaV1 | undefined = any>(overrides?: (Partial<{
    name?: string;
    description?: string;
} & BaseEvalOptions & {
    threshold: number;
}> & {
    middleware?: import("./types").EvalMiddleware<TAgentInput extends import("@agentuity/core").StandardSchemaV1<unknown, unknown> ? import("@agentuity/core").InferOutput<TAgentInput> : any, TAgentOutput extends import("@agentuity/core").StandardSchemaV1<unknown, unknown> ? import("@agentuity/core").InferOutput<TAgentOutput> : any, {
        request: string;
    } & {
        context?: string | undefined;
    }, {
        response: string;
    } & {}> | undefined;
    onStart?: ((ctx: import("@agentuity/runtime").EvalContext, input: TAgentInput extends import("@agentuity/core").StandardSchemaV1<unknown, unknown> ? import("@agentuity/core").InferOutput<TAgentInput> : any, output: TAgentOutput extends import("@agentuity/core").StandardSchemaV1<unknown, unknown> ? import("@agentuity/core").InferOutput<TAgentOutput> : any) => void | Promise<void>) | undefined;
    onComplete?: ((ctx: import("@agentuity/runtime").EvalContext, input: TAgentInput extends import("@agentuity/core").StandardSchemaV1<unknown, unknown> ? import("@agentuity/core").InferOutput<TAgentInput> : any, output: TAgentOutput extends import("@agentuity/core").StandardSchemaV1<unknown, unknown> ? import("@agentuity/core").InferOutput<TAgentOutput> : any, result: import("@agentuity/runtime").EvalHandlerResult) => void | Promise<void>) | undefined;
}) | undefined) => import("@agentuity/runtime").CreateEvalConfig<any, any> & {
    name: string;
    options: PolitenessEvalOptions;
};
export {};
//# sourceMappingURL=politeness.d.ts.map