import { z } from 'zod';
export const EvalRunStartEventSchema = z
    .object({
    id: z.string().describe('the eval run id'),
    sessionId: z.string().describe('the session id'),
    evalId: z.string().describe('the evaluation record id (evalid_...)'),
    evalIdentifier: z.string().describe('the stable eval identifier (eval_...)'),
    orgId: z.string().describe('the organization id'),
    projectId: z.string().describe('the project id'),
    devmode: z.boolean().describe('true if running in devmode'),
    deploymentId: z.string().optional().describe('the deployment id'),
    spanId: z.string().optional().describe('the span id'),
})
    .describe('The event to record an eval run started');
export const EvalRunCompleteEventSchema = z
    .object({
    id: z.string().describe('the eval run id'),
    error: z.string().optional().describe('the optional error message if the eval run failed'),
    result: z.any().optional().describe('the eval run result'),
})
    .describe('The event to record an eval run completed');
export const EvalRunStartEventDelayedSchema = z.intersection(EvalRunStartEventSchema, z.object({ timestamp: z.number().describe('the event timestamp in epoch') }));
export const EvalRunCompleteEventDelayedSchema = z.intersection(EvalRunCompleteEventSchema, z.object({ timestamp: z.number().describe('the event timestamp in epoch') }));
//# sourceMappingURL=evalrun.js.map