import { StreamStorageService, type Logger } from '@agentuity/core';
import type { AuthData, Config, GlobalOptions, ProjectConfig } from '../../../types';
/**
 * Create a storage adapter for stream operations that create new streams.
 * This is used by the `stream create` command.
 *
 * For listing and deleting streams, use the CLI API endpoints (streamList, streamGet)
 * which handle org resolution automatically based on user's org membership.
 *
 * @param ctx - Command context including auth, region, and optional project context
 * @returns A StreamStorageService instance configured for the org
 */
export declare function createStorageAdapter(ctx: {
    logger: Logger;
    projectDir: string;
    auth: AuthData;
    region: string;
    project?: ProjectConfig;
    config: Config | null;
    options: GlobalOptions;
}): Promise<StreamStorageService>;
/**
 * Create a storage adapter for a specific org ID.
 * Used when listing streams across multiple orgs.
 */
export declare function createStorageAdapterForOrg(ctx: {
    logger: Logger;
    auth: AuthData;
    region: string;
    orgId: string;
}): StreamStorageService;
//# sourceMappingURL=util.d.ts.map