import type { Plugin } from 'vite';
import type { LogLevel, DeployOptions } from '../../../types';
export { browserEnvPlugin } from './browser-env-plugin';
export { publicAssetPathPlugin } from './public-asset-path-plugin';
export interface AgentuityPluginOptions {
    dev?: boolean;
    rootDir: string;
    projectId?: string;
    orgId?: string;
    deploymentId?: string;
    logLevel?: LogLevel;
    deploymentOptions?: DeployOptions;
}
/**
 * Agentuity Vite Plugin
 *
 * Responsibilities:
 * - Agent discovery via READ-ONLY AST analysis
 * - Route discovery via READ-ONLY AST analysis
 * - Registry generation (src/generated/registry.ts)
 * - Lifecycle types generation (src/generated/lifecycle.d.ts)
 * - Entry file generation (src/generated/app.ts)
 * - Virtual modules (virtual:agentuity/agents, virtual:agentuity/routes)
 * - Metadata generation (agentuity.metadata.json)
 */
export declare function agentuityPlugin(options: AgentuityPluginOptions): Plugin;
//# sourceMappingURL=index.d.ts.map