import type { Logger } from '@agentuity/core';
import type { Readable, Writable } from 'node:stream';
import { APIClient } from '../api';
import type { SandboxRunOptions, SandboxRunResult } from '@agentuity/core';
export interface SandboxRunParams {
    options: SandboxRunOptions;
    orgId?: string;
    region?: string;
    apiKey?: string;
    signal?: AbortSignal;
    stdin?: Readable;
    stdout?: Writable;
    stderr?: Writable;
    logger?: Logger;
}
/**
 * Creates a sandbox, executes a command, and waits for completion.
 *
 * This is a high-level convenience function that handles the full lifecycle:
 * creating a sandbox, streaming I/O, polling for completion, and cleanup.
 *
 * @param client - The API client to use for the request
 * @param params - Parameters including command options, I/O streams, and timeout settings
 * @returns The run result including exit code and duration
 * @throws {SandboxResponseError} If sandbox creation fails, execution times out, or is cancelled
 */
export declare function sandboxRun(client: APIClient, params: SandboxRunParams): Promise<SandboxRunResult>;
//# sourceMappingURL=run.d.ts.map