import { z } from 'zod';
import { APIResponseSchema } from '../api';
import { RegionResponseError } from './util';
export const ListRegionsResponse = z.array(z.object({
    region: z.string().describe('the region identifier'),
    description: z.string().describe('the human-readable description of the region'),
}));
export const ListRegionsResponseSchema = APIResponseSchema(ListRegionsResponse);
/**
 * List all available cloud regions
 *
 * @param client
 * @returns
 */
export async function listRegions(client) {
    const resp = await client.request('GET', '/cli/region', ListRegionsResponseSchema);
    if (resp.success) {
        return resp.data;
    }
    throw new RegionResponseError({ message: resp.message });
}
//# sourceMappingURL=list.js.map