import { z } from 'zod';
import { APIClient } from '../api';
export declare const UpdateRegionRequestSchema: z.ZodObject<{
    cloudRegion: z.ZodString;
}, z.core.$strip>;
/**
 * Update a project's cloud region
 *
 * @param client - The API client
 * @param projectId - The project id to update
 * @param region - The new cloud region
 * @returns The project id on success
 */
export declare function projectUpdateRegion(client: APIClient, projectId: string, region: string): Promise<{
    id: string;
}>;
//# sourceMappingURL=update-region.d.ts.map