import { z } from 'zod';
import { APIClient } from '../api';
import type { Project } from './get';
export declare const ProjectEnvUpdateRequestSchema: z.ZodObject<{
    id: z.ZodString;
    env: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
    secrets: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
}, z.core.$strip>;
type ProjectEnvUpdateRequest = z.infer<typeof ProjectEnvUpdateRequestSchema>;
/**
 * Update environment variables and/or secrets for a project.
 * This will merge the provided env/secrets with existing values.
 * Keys starting with 'AGENTUITY_' should be filtered out before calling this function.
 */
export declare function projectEnvUpdate(client: APIClient, request: ProjectEnvUpdateRequest): Promise<Project>;
export {};
//# sourceMappingURL=env-update.d.ts.map