import { z } from 'zod';
import { APIClient } from '../api';
export declare const ProjectEnvDeleteRequestSchema: z.ZodObject<{
    id: z.ZodString;
    env: z.ZodOptional<z.ZodArray<z.ZodString>>;
    secrets: z.ZodOptional<z.ZodArray<z.ZodString>>;
}, z.core.$strip>;
type ProjectEnvDeleteRequest = z.infer<typeof ProjectEnvDeleteRequestSchema>;
/**
 * Delete environment variables and/or secrets from a project.
 * Provide arrays of keys to delete.
 */
export declare function projectEnvDelete(client: APIClient, request: ProjectEnvDeleteRequest): Promise<void>;
export {};
//# sourceMappingURL=env-delete.d.ts.map