import { z } from 'zod';
import { APIClient } from '../api';
export declare const TableColumnSchema: z.ZodObject<{
    name: z.ZodString;
    data_type: z.ZodString;
    is_nullable: z.ZodBoolean;
    default_value: z.ZodOptional<z.ZodString>;
    is_primary_key: z.ZodBoolean;
}, z.core.$strip>;
export declare const TableSchemaSchema: z.ZodObject<{
    table_name: z.ZodString;
    columns: z.ZodArray<z.ZodObject<{
        name: z.ZodString;
        data_type: z.ZodString;
        is_nullable: z.ZodBoolean;
        default_value: z.ZodOptional<z.ZodString>;
        is_primary_key: z.ZodBoolean;
    }, z.core.$strip>>;
}, z.core.$strip>;
export type TableColumn = z.infer<typeof TableColumnSchema>;
export type TableSchema = z.infer<typeof TableSchemaSchema>;
interface DbTablesRequest {
    database: string;
    orgId: string;
    region: string;
}
export declare function dbTables(client: APIClient, request: DbTablesRequest): Promise<TableSchema[]>;
export declare function generateCreateTableSQL(table: TableSchema): string;
export {};
//# sourceMappingURL=tables.d.ts.map