import { z } from 'zod';
import { APIClient } from '../api';
export declare const APIKeySchema: z.ZodObject<{
    id: z.ZodString;
    name: z.ZodString;
    orgId: z.ZodString;
    type: z.ZodString;
    expiresAt: z.ZodNullable<z.ZodString>;
    lastUsedAt: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    createdAt: z.ZodString;
    project: z.ZodOptional<z.ZodNullable<z.ZodObject<{
        id: z.ZodString;
        name: z.ZodString;
    }, z.core.$strip>>>;
}, z.core.$strip>;
export declare const APIKeyListResponseArray: z.ZodArray<z.ZodObject<{
    id: z.ZodString;
    name: z.ZodString;
    orgId: z.ZodString;
    type: z.ZodString;
    expiresAt: z.ZodNullable<z.ZodString>;
    lastUsedAt: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    createdAt: z.ZodString;
    project: z.ZodOptional<z.ZodNullable<z.ZodObject<{
        id: z.ZodString;
        name: z.ZodString;
    }, z.core.$strip>>>;
}, z.core.$strip>>;
export declare const APIKeyListResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodArray<z.ZodObject<{
        id: z.ZodString;
        name: z.ZodString;
        orgId: z.ZodString;
        type: z.ZodString;
        expiresAt: z.ZodNullable<z.ZodString>;
        lastUsedAt: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        createdAt: z.ZodString;
        project: z.ZodOptional<z.ZodNullable<z.ZodObject<{
            id: z.ZodString;
            name: z.ZodString;
        }, z.core.$strip>>>;
    }, z.core.$strip>>;
}, z.core.$strip>], "success">;
export type APIKeyListResponse = z.infer<typeof APIKeyListResponseSchema>;
export type APIKeyList = z.infer<typeof APIKeyListResponseArray>;
export type APIKey = z.infer<typeof APIKeySchema>;
export interface APIKeyListRequest {
    orgId?: string;
    projectId?: string;
}
/**
 * List all API keys
 *
 * @param client
 * @param request optional filters for orgId and projectId
 * @returns
 */
export declare function apikeyList(client: APIClient, request?: APIKeyListRequest): Promise<APIKeyList>;
//# sourceMappingURL=list.d.ts.map