import { type ExportResult } from '@opentelemetry/core';
import { type PushMetricExporter, type ResourceMetrics, AggregationTemporality, InstrumentType } from '@opentelemetry/sdk-metrics';
/**
 * JSONL implementation of the PushMetricExporter interface
 * Writes metrics to a timestamped JSONL file
 */
export declare class JSONLMetricExporter implements PushMetricExporter {
    private currentFile;
    private readonly basePath;
    private readonly filePrefix;
    /**
     * Creates a new JSONL metric exporter
     * @param basePath - Directory to store the JSONL files
     */
    constructor(basePath: string);
    private ensureDirectory;
    private getOrCreateFile;
    /**
     * Exports metrics to a JSONL file
     *
     * @param metrics - The resource metrics to export
     * @param resultCallback - Callback function to report the export result
     */
    export(metrics: ResourceMetrics, resultCallback: (result: ExportResult) => void): void;
    /**
     * Shuts down the exporter
     *
     * @returns A promise that resolves when shutdown is complete
     */
    shutdown(): Promise<void>;
    /**
     * Forces a flush of any pending data
     */
    forceFlush(): Promise<void>;
    /**
     * Selects the aggregation temporality for the given instrument type
     */
    selectAggregationTemporality?(_instrumentType: InstrumentType): AggregationTemporality;
}
//# sourceMappingURL=jsonl-metric-exporter.d.ts.map