import { type Tracer } from '@opentelemetry/api';
import type { Logger } from './logger';
/**
 * returns true if wait until is pending
 * @returns boolean
 */
export declare function hasWaitUntilPending(): boolean;
export default class WaitUntilHandler {
    private promises;
    private tracer;
    private started;
    private hasCalledWaitUntilAll;
    constructor(tracer: Tracer);
    waitUntil(promise: Promise<void> | (() => void | Promise<void>), options?: {
        noSpan?: boolean;
    }): void;
    hasPending(): boolean;
    /**
     * Returns a snapshot of currently pending promises.
     * This allows waiting for specific promises without including promises added later.
     * Useful to avoid deadlock when the caller will add their own promise via waitUntil.
     */
    getPendingSnapshot(): Promise<void>[];
    /**
     * Wait for a specific set of promises to complete.
     * Unlike waitUntilAll, this doesn't mark the handler as "all called" and
     * allows additional waitUntil calls afterward.
     */
    waitForPromises(promises: Promise<void>[], logger: Logger, sessionId: string): Promise<void>;
    waitUntilAll(logger: Logger, sessionId: string): Promise<void>;
}
//# sourceMappingURL=_waituntil.d.ts.map