import type { Logger, GlobalOptions } from './types';
import { type StructuredError, ErrorCode } from './errors';
/**
 * Enhanced logger wrapper that supports structured errors
 */
export declare class CLILogger implements Logger {
    private logger;
    private options;
    constructor(logger: Logger, options: GlobalOptions);
    /**
     * Exit with a structured error (supports --error-format=json)
     */
    fatalWithError(error: StructuredError): never;
    trace(message: string, ...args: unknown[]): void;
    debug(message: string, ...args: unknown[]): void;
    info(message: string, ...args: unknown[]): void;
    warn(message: string, ...args: unknown[]): void;
    error(message: string, ...args: unknown[]): void;
    fatal(message: string, errorCode?: ErrorCode, ...args: unknown[]): never;
    private formatMessage;
    child(opts: Record<string, unknown>): Logger;
}
/**
 * Wrap a logger with CLI error handling capabilities
 */
export declare function wrapLogger(logger: Logger, options: GlobalOptions): CLILogger;
//# sourceMappingURL=cli-logger.d.ts.map