export interface ResourceValidationSuccess {
    valid: true;
    value: number;
}
export interface ResourceValidationFailure {
    valid: false;
    error: string;
}
export type ResourceValidationResult = ResourceValidationSuccess | ResourceValidationFailure;
/**
 * Validates and parses a CPU spec string.
 * Valid formats:
 * - "500m" (millicores)
 * - "1" or "2" (cores, converted to millicores)
 * - "0.5" (fractional cores, converted to millicores)
 */
export declare function validateCPUSpec(input: string): ResourceValidationResult;
/**
 * Validates and parses a memory/disk spec string.
 * Valid formats:
 * - "500Mi", "1Gi", "2Ti" (binary units)
 * - "500M", "1G", "2T" (decimal units)
 * - "1.5Gi", "0.5G" (decimal fractions with units)
 * - "1073741824" (raw bytes)
 */
export declare function validateMemorySpec(input: string, fieldName?: 'memory' | 'disk'): ResourceValidationResult;
export interface ResourcesConfig {
    cpu?: string;
    memory?: string;
    disk?: string;
}
export interface ValidatedResources {
    cpuUnits?: number;
    memoryUnits?: number;
    diskUnits?: number;
}
/**
 * Validates all resource specs and returns either validated values or an array of errors.
 */
export declare function validateResources(resources: ResourcesConfig): {
    valid: true;
    values: ValidatedResources;
} | {
    valid: false;
    errors: string[];
};
//# sourceMappingURL=resources.d.ts.map