import { APIClient } from '@agentuity/server';
import { type SessionEventProvider, type SessionStartEvent, type SessionCompleteEvent, type Logger } from '@agentuity/core';
/**
 * An implementation of the SessionEventProvider which uses HTTP for delivery.
 *
 * This provider checks that the event has required fields (orgId, projectId for start events)
 * before sending to the backend. If required fields are missing, the event is silently skipped.
 */
export declare class HTTPSessionEventProvider implements SessionEventProvider {
    private apiClient;
    private logger;
    constructor(client: APIClient, logger: Logger);
    /**
     * Check if a start event has all required fields for HTTP delivery
     */
    private canSendStartEvent;
    /**
     * called when the session starts
     *
     * @param event SessionStartEvent
     */
    start(event: SessionStartEvent): Promise<void>;
    /**
     * Track session IDs that have been started (to know if we should send complete)
     */
    private startedSessions;
    /**
     * called when the session completes
     *
     * @param event SessionCompleteEvent
     */
    complete(event: SessionCompleteEvent): Promise<void>;
}
//# sourceMappingURL=http.d.ts.map