/**
 * Utility to send notifications directly to workbench clients via WebSocket
 */
export interface WorkbenchNotifyOptions {
    port?: number;
    message: 'restarting' | 'alive';
}
/**
 * Send a notification directly to workbench clients via WebSocket
 *
 * @param options - Configuration for the notification
 * @returns Promise that resolves when notification is sent
 *
 * @example
 * ```typescript
 * // Notify clients that server is restarting
 * await notifyWorkbenchClients({
 *   baseUrl: 'ws://localhost:3500',
 *   message: 'restarting'
 * });
 *
 * // Notify clients that server is alive
 * await notifyWorkbenchClients({
 *   message: 'alive'
 * });
 * ```
 */
export declare function notifyWorkbenchClients(options: WorkbenchNotifyOptions): Promise<void>;
//# sourceMappingURL=workbench-notify.d.ts.map