/* eslint-disable */
// @ts-nocheck
/**
 * TSC Output Parser
 *
 * Parses TypeScript compiler output into structured JSON format.
 *
 * This is an internalized version of @aivenio/tsc-output-parser.
 * Original source: https://github.com/Aiven-Open/tsc-output-parser
 *
 * Copyright Aiven
 * Licensed under the Apache License, Version 2.0
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Generated by PEG.js v. 0.10.0 (ts-pegjs plugin v. 0.2.7)
 * https://pegjs.org/   https://github.com/metadevpro/ts-pegjs
 *
 * NOTE: This file is auto-generated. Do not edit manually.
 * TypeScript and ESLint checks are disabled for this file.
 */
class SyntaxError extends Error {
    static buildMessage(expected, found) {
        function hex(ch) {
            return ch.charCodeAt(0).toString(16).toUpperCase();
        }
        function literalEscape(s) {
            return s
                .replace(/\\/g, '\\\\')
                .replace(/"/g, '\\"')
                .replace(/\0/g, '\\0')
                .replace(/\t/g, '\\t')
                .replace(/\n/g, '\\n')
                .replace(/\r/g, '\\r')
                .replace(/[\x00-\x0F]/g, (ch) => '\\x0' + hex(ch))
                .replace(/[\x10-\x1F\x7F-\x9F]/g, (ch) => '\\x' + hex(ch));
        }
        function classEscape(s) {
            return s
                .replace(/\\/g, '\\\\')
                .replace(/\]/g, '\\]')
                .replace(/\^/g, '\\^')
                .replace(/-/g, '\\-')
                .replace(/\0/g, '\\0')
                .replace(/\t/g, '\\t')
                .replace(/\n/g, '\\n')
                .replace(/\r/g, '\\r')
                .replace(/[\x00-\x0F]/g, (ch) => '\\x0' + hex(ch))
                .replace(/[\x10-\x1F\x7F-\x9F]/g, (ch) => '\\x' + hex(ch));
        }
        function describeExpectation(expectation) {
            switch (expectation.type) {
                case 'literal':
                    return '"' + literalEscape(expectation.text) + '"';
                case 'class': {
                    const escapedParts = expectation.parts.map((part) => {
                        return Array.isArray(part)
                            ? classEscape(part[0]) + '-' + classEscape(part[1])
                            : classEscape(part);
                    });
                    return '[' + (expectation.inverted ? '^' : '') + escapedParts + ']';
                }
                case 'any':
                    return 'any character';
                case 'end':
                    return 'end of input';
                case 'other':
                    return expectation.description;
            }
        }
        function describeExpected(expected1) {
            const descriptions = expected1.map(describeExpectation);
            let i;
            let j;
            descriptions.sort();
            if (descriptions.length > 0) {
                for (i = 1, j = 1; i < descriptions.length; i++) {
                    const prevDesc = descriptions[i - 1];
                    const currDesc = descriptions[i];
                    if (prevDesc !== currDesc && currDesc !== undefined) {
                        descriptions[j] = currDesc;
                        j++;
                    }
                }
                descriptions.length = j;
            }
            switch (descriptions.length) {
                case 1:
                    return descriptions[0] ?? '';
                case 2:
                    return (descriptions[0] ?? '') + ' or ' + (descriptions[1] ?? '');
                default:
                    return (descriptions.slice(0, -1).join(', ') +
                        ', or ' +
                        (descriptions[descriptions.length - 1] ?? ''));
            }
        }
        function describeFound(found1) {
            return found1 ? '"' + literalEscape(found1) + '"' : 'end of input';
        }
        return 'Expected ' + describeExpected(expected) + ' but ' + describeFound(found) + ' found.';
    }
    message;
    expected;
    found;
    location;
    name;
    constructor(message, expected, found, location) {
        super();
        this.message = message;
        this.expected = expected;
        this.found = found;
        this.location = location;
        this.name = 'SyntaxError';
        if (typeof Error.captureStackTrace === 'function') {
            Error.captureStackTrace(this, SyntaxError);
        }
    }
}
function peg$parse(input, options) {
    options = options !== undefined ? options : {};
    const peg$FAILED = {};
    const peg$startRuleFunctions = { Main: peg$parseMain };
    let peg$startRuleFunction = peg$parseMain;
    const peg$c0 = function (items) {
        return items;
    };
    const peg$c1 = ':';
    const peg$c2 = peg$literalExpectation(':', false);
    const peg$c3 = function (path, cursor, tsError, message) {
        return {
            type: 'Item',
            value: {
                path,
                cursor,
                tsError,
                message,
            },
        };
    };
    const peg$c4 = function (line, extraLines) {
        return {
            type: 'Message',
            value: `${line}${extraLines.join('')}`,
        };
    };
    const peg$c5 = function (indent, tail) {
        return `${indent}${tail}`;
    };
    const peg$c6 = '  ';
    const peg$c7 = peg$literalExpectation('  ', false);
    const peg$c8 = function (indent) {
        return indent;
    };
    const peg$c9 = ' TS';
    const peg$c10 = peg$literalExpectation(' TS', false);
    const peg$c11 = function (type, num) {
        return {
            type: 'TsError',
            value: {
                type,
                errorString: `TS${num}`,
            },
        };
    };
    const peg$c12 = 'error';
    const peg$c13 = peg$literalExpectation('error', false);
    const peg$c14 = 'warning';
    const peg$c15 = peg$literalExpectation('warning', false);
    const peg$c16 = function (type) {
        return type;
    };
    const peg$c17 = '(';
    const peg$c18 = peg$literalExpectation('(', false);
    const peg$c19 = ',';
    const peg$c20 = peg$literalExpectation(',', false);
    const peg$c21 = ')';
    const peg$c22 = peg$literalExpectation(')', false);
    const peg$c23 = function (line, col) {
        return {
            type: 'Cursor',
            value: {
                line,
                col,
            },
        };
    };
    const peg$c24 = /^[^\n\r(]/;
    const peg$c25 = peg$classExpectation(['\n', '\r', '('], true, false);
    const peg$c26 = function (path) {
        return {
            type: 'Path',
            value: path.join(''),
        };
    };
    const peg$c27 = '\n';
    const peg$c28 = peg$literalExpectation('\n', false);
    const peg$c29 = function (text, newlines) {
        return `${text.join('')}${newlines.join('')}`;
    };
    const peg$c30 = /^[^\n\r]/;
    const peg$c31 = peg$classExpectation(['\n', '\r'], true, false);
    const peg$c32 = /^[0-9]/;
    const peg$c33 = peg$classExpectation([['0', '9']], false, false);
    const peg$c34 = function (digits) {
        return parseInt(digits.join(''), 10);
    };
    const peg$c35 = /^[ \t\r\n]/;
    const peg$c36 = peg$classExpectation([' ', '\t', '\r', '\n'], false, false);
    const peg$c37 = function () {
        return null;
    };
    let peg$currPos = 0;
    let peg$savedPos = 0;
    const peg$posDetailsCache = [{ line: 1, column: 1 }];
    let peg$maxFailPos = 0;
    let peg$maxFailExpected = [];
    let peg$silentFails = 0;
    const peg$resultsCache = {};
    let peg$result;
    if (options.startRule !== undefined) {
        if (!(options.startRule in peg$startRuleFunctions)) {
            throw new Error('Can\'t start parsing from rule "' + options.startRule + '".');
        }
        const startFn = peg$startRuleFunctions[options.startRule];
        if (startFn) {
            peg$startRuleFunction = startFn;
        }
    }
    function peg$literalExpectation(text1, ignoreCase) {
        return { type: 'literal', text: text1, ignoreCase: ignoreCase };
    }
    function peg$classExpectation(parts, inverted, ignoreCase) {
        return { type: 'class', parts: parts, inverted: inverted, ignoreCase: ignoreCase };
    }
    function peg$endExpectation() {
        return { type: 'end' };
    }
    function peg$computePosDetails(pos) {
        let details = peg$posDetailsCache[pos];
        let p;
        if (details) {
            return details;
        }
        else {
            p = pos - 1;
            while (!peg$posDetailsCache[p]) {
                p--;
            }
            const cachedDetails = peg$posDetailsCache[p];
            details = {
                line: cachedDetails?.line ?? 1,
                column: cachedDetails?.column ?? 1,
            };
            while (p < pos) {
                if (input.charCodeAt(p) === 10) {
                    details.line++;
                    details.column = 1;
                }
                else {
                    details.column++;
                }
                p++;
            }
            peg$posDetailsCache[pos] = details;
            return details;
        }
    }
    function peg$computeLocation(startPos, endPos) {
        const startPosDetails = peg$computePosDetails(startPos);
        const endPosDetails = peg$computePosDetails(endPos);
        return {
            start: {
                offset: startPos,
                line: startPosDetails.line,
                column: startPosDetails.column,
            },
            end: {
                offset: endPos,
                line: endPosDetails.line,
                column: endPosDetails.column,
            },
        };
    }
    function peg$fail(expected1) {
        if (peg$currPos < peg$maxFailPos) {
            return;
        }
        if (peg$currPos > peg$maxFailPos) {
            peg$maxFailPos = peg$currPos;
            peg$maxFailExpected = [];
        }
        peg$maxFailExpected.push(expected1);
    }
    function peg$buildStructuredError(expected1, found, location1) {
        return new SyntaxError(SyntaxError.buildMessage(expected1, found), expected1, found, location1);
    }
    function peg$parseMain() {
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        let s0, s1, s2, s3;
        const key = peg$currPos * 13 + 0;
        const cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        s1 = peg$parse_();
        if (s1 !== peg$FAILED) {
            s2 = [];
            s3 = peg$parseItem();
            while (s3 !== peg$FAILED) {
                s2.push(s3);
                s3 = peg$parseItem();
            }
            if (s2 !== peg$FAILED) {
                s3 = peg$parse_();
                if (s3 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c0(s2);
                    s0 = s1;
                }
                else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                }
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        else {
            peg$currPos = s0;
            s0 = peg$FAILED;
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseItem() {
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        let s0, s1, s2, s3, s4, s5, s6, s7, s8;
        const key = peg$currPos * 13 + 1;
        const cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        s1 = peg$parsePath();
        if (s1 !== peg$FAILED) {
            s2 = peg$parseCursor();
            if (s2 !== peg$FAILED) {
                if (input.charCodeAt(peg$currPos) === 58) {
                    s3 = peg$c1;
                    peg$currPos++;
                }
                else {
                    s3 = peg$FAILED;
                    if (peg$silentFails === 0) {
                        peg$fail(peg$c2);
                    }
                }
                if (s3 !== peg$FAILED) {
                    s4 = peg$parse_();
                    if (s4 !== peg$FAILED) {
                        s5 = peg$parseTsError();
                        if (s5 !== peg$FAILED) {
                            s6 = peg$parse_();
                            if (s6 !== peg$FAILED) {
                                if (input.charCodeAt(peg$currPos) === 58) {
                                    s7 = peg$c1;
                                    peg$currPos++;
                                }
                                else {
                                    s7 = peg$FAILED;
                                    if (peg$silentFails === 0) {
                                        peg$fail(peg$c2);
                                    }
                                }
                                if (s7 !== peg$FAILED) {
                                    s8 = peg$parseMessage();
                                    if (s8 !== peg$FAILED) {
                                        peg$savedPos = s0;
                                        s1 = peg$c3(s1, s2, s5, s8);
                                        s0 = s1;
                                    }
                                    else {
                                        peg$currPos = s0;
                                        s0 = peg$FAILED;
                                    }
                                }
                                else {
                                    peg$currPos = s0;
                                    s0 = peg$FAILED;
                                }
                            }
                            else {
                                peg$currPos = s0;
                                s0 = peg$FAILED;
                            }
                        }
                        else {
                            peg$currPos = s0;
                            s0 = peg$FAILED;
                        }
                    }
                    else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                }
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        else {
            peg$currPos = s0;
            s0 = peg$FAILED;
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseMessage() {
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        let s0, s1, s2, s3;
        const key = peg$currPos * 13 + 2;
        const cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        s1 = peg$parseTextLine();
        if (s1 !== peg$FAILED) {
            s2 = [];
            s3 = peg$parseMessageExtraLine();
            while (s3 !== peg$FAILED) {
                s2.push(s3);
                s3 = peg$parseMessageExtraLine();
            }
            if (s2 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c4(s1, s2);
                s0 = s1;
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        else {
            peg$currPos = s0;
            s0 = peg$FAILED;
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseMessageExtraLine() {
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        let s0, s1, s2;
        const key = peg$currPos * 13 + 3;
        const cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        s1 = peg$parseMessageExtraLineStart();
        if (s1 !== peg$FAILED) {
            s2 = peg$parseTextLine();
            if (s2 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c5(s1, s2);
                s0 = s1;
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        else {
            peg$currPos = s0;
            s0 = peg$FAILED;
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseMessageExtraLineStart() {
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        let s0, s1;
        const key = peg$currPos * 13 + 4;
        const cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        if (input.substr(peg$currPos, 2) === peg$c6) {
            s1 = peg$c6;
            peg$currPos += 2;
        }
        else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c7);
            }
        }
        if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c8(s1);
        }
        s0 = s1;
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseTsError() {
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        let s0, s1, s2, s3;
        const key = peg$currPos * 13 + 5;
        const cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        s1 = peg$parseTsErrorType();
        if (s1 !== peg$FAILED) {
            if (input.substr(peg$currPos, 3) === peg$c9) {
                s2 = peg$c9;
                peg$currPos += 3;
            }
            else {
                s2 = peg$FAILED;
                if (peg$silentFails === 0) {
                    peg$fail(peg$c10);
                }
            }
            if (s2 !== peg$FAILED) {
                s3 = peg$parseInteger();
                if (s3 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c11(s1, s3);
                    s0 = s1;
                }
                else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                }
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        else {
            peg$currPos = s0;
            s0 = peg$FAILED;
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseTsErrorType() {
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        let s0, s1;
        const key = peg$currPos * 13 + 6;
        const cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        if (input.substr(peg$currPos, 5) === peg$c12) {
            s1 = peg$c12;
            peg$currPos += 5;
        }
        else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c13);
            }
        }
        if (s1 === peg$FAILED) {
            if (input.substr(peg$currPos, 7) === peg$c14) {
                s1 = peg$c14;
                peg$currPos += 7;
            }
            else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) {
                    peg$fail(peg$c15);
                }
            }
        }
        if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c16(s1);
        }
        s0 = s1;
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseCursor() {
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        let s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;
        const key = peg$currPos * 13 + 7;
        const cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 40) {
            s1 = peg$c17;
            peg$currPos++;
        }
        else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c18);
            }
        }
        if (s1 !== peg$FAILED) {
            s2 = peg$parse_();
            if (s2 !== peg$FAILED) {
                s3 = peg$parseInteger();
                if (s3 !== peg$FAILED) {
                    s4 = peg$parse_();
                    if (s4 !== peg$FAILED) {
                        if (input.charCodeAt(peg$currPos) === 44) {
                            s5 = peg$c19;
                            peg$currPos++;
                        }
                        else {
                            s5 = peg$FAILED;
                            if (peg$silentFails === 0) {
                                peg$fail(peg$c20);
                            }
                        }
                        if (s5 !== peg$FAILED) {
                            s6 = peg$parse_();
                            if (s6 !== peg$FAILED) {
                                s7 = peg$parseInteger();
                                if (s7 !== peg$FAILED) {
                                    s8 = peg$parse_();
                                    if (s8 !== peg$FAILED) {
                                        if (input.charCodeAt(peg$currPos) === 41) {
                                            s9 = peg$c21;
                                            peg$currPos++;
                                        }
                                        else {
                                            s9 = peg$FAILED;
                                            if (peg$silentFails === 0) {
                                                peg$fail(peg$c22);
                                            }
                                        }
                                        if (s9 !== peg$FAILED) {
                                            peg$savedPos = s0;
                                            s1 = peg$c23(s3, s7);
                                            s0 = s1;
                                        }
                                        else {
                                            peg$currPos = s0;
                                            s0 = peg$FAILED;
                                        }
                                    }
                                    else {
                                        peg$currPos = s0;
                                        s0 = peg$FAILED;
                                    }
                                }
                                else {
                                    peg$currPos = s0;
                                    s0 = peg$FAILED;
                                }
                            }
                            else {
                                peg$currPos = s0;
                                s0 = peg$FAILED;
                            }
                        }
                        else {
                            peg$currPos = s0;
                            s0 = peg$FAILED;
                        }
                    }
                    else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                }
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        else {
            peg$currPos = s0;
            s0 = peg$FAILED;
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parsePath() {
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        let s0, s1, s2;
        const key = peg$currPos * 13 + 8;
        const cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        s1 = [];
        if (peg$c24.test(input.charAt(peg$currPos))) {
            s2 = input.charAt(peg$currPos);
            peg$currPos++;
        }
        else {
            s2 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c25);
            }
        }
        if (s2 !== peg$FAILED) {
            while (s2 !== peg$FAILED) {
                s1.push(s2);
                if (peg$c24.test(input.charAt(peg$currPos))) {
                    s2 = input.charAt(peg$currPos);
                    peg$currPos++;
                }
                else {
                    s2 = peg$FAILED;
                    if (peg$silentFails === 0) {
                        peg$fail(peg$c25);
                    }
                }
            }
        }
        else {
            s1 = peg$FAILED;
        }
        if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c26(s1);
        }
        s0 = s1;
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseTextLine() {
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        let s0, s1, s2, s3;
        const key = peg$currPos * 13 + 9;
        const cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        s1 = [];
        s2 = peg$parseAnyCharExceptNewLine();
        if (s2 !== peg$FAILED) {
            while (s2 !== peg$FAILED) {
                s1.push(s2);
                s2 = peg$parseAnyCharExceptNewLine();
            }
        }
        else {
            s1 = peg$FAILED;
        }
        if (s1 !== peg$FAILED) {
            s2 = [];
            if (input.charCodeAt(peg$currPos) === 10) {
                s3 = peg$c27;
                peg$currPos++;
            }
            else {
                s3 = peg$FAILED;
                if (peg$silentFails === 0) {
                    peg$fail(peg$c28);
                }
            }
            while (s3 !== peg$FAILED) {
                s2.push(s3);
                if (input.charCodeAt(peg$currPos) === 10) {
                    s3 = peg$c27;
                    peg$currPos++;
                }
                else {
                    s3 = peg$FAILED;
                    if (peg$silentFails === 0) {
                        peg$fail(peg$c28);
                    }
                }
            }
            if (s2 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c29(s1, s2);
                s0 = s1;
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        else {
            peg$currPos = s0;
            s0 = peg$FAILED;
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseAnyCharExceptNewLine() {
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        let s0;
        const key = peg$currPos * 13 + 10;
        const cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        if (peg$c30.test(input.charAt(peg$currPos))) {
            s0 = input.charAt(peg$currPos);
            peg$currPos++;
        }
        else {
            s0 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c31);
            }
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseInteger() {
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        let s0, s1, s2;
        const key = peg$currPos * 13 + 11;
        const cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        s1 = [];
        if (peg$c32.test(input.charAt(peg$currPos))) {
            s2 = input.charAt(peg$currPos);
            peg$currPos++;
        }
        else {
            s2 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c33);
            }
        }
        if (s2 !== peg$FAILED) {
            while (s2 !== peg$FAILED) {
                s1.push(s2);
                if (peg$c32.test(input.charAt(peg$currPos))) {
                    s2 = input.charAt(peg$currPos);
                    peg$currPos++;
                }
                else {
                    s2 = peg$FAILED;
                    if (peg$silentFails === 0) {
                        peg$fail(peg$c33);
                    }
                }
            }
        }
        else {
            s1 = peg$FAILED;
        }
        if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c34(s1);
        }
        s0 = s1;
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parse_() {
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        let s0, s1, s2;
        const key = peg$currPos * 13 + 12;
        const cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        s1 = [];
        if (peg$c35.test(input.charAt(peg$currPos))) {
            s2 = input.charAt(peg$currPos);
            peg$currPos++;
        }
        else {
            s2 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c36);
            }
        }
        while (s2 !== peg$FAILED) {
            s1.push(s2);
            if (peg$c35.test(input.charAt(peg$currPos))) {
                s2 = input.charAt(peg$currPos);
                peg$currPos++;
            }
            else {
                s2 = peg$FAILED;
                if (peg$silentFails === 0) {
                    peg$fail(peg$c36);
                }
            }
        }
        if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c37();
        }
        s0 = s1;
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    peg$result = peg$startRuleFunction();
    if (peg$result !== peg$FAILED && peg$currPos === input.length) {
        return peg$result;
    }
    else {
        if (peg$result !== peg$FAILED && peg$currPos < input.length) {
            peg$fail(peg$endExpectation());
        }
        throw peg$buildStructuredError(peg$maxFailExpected, peg$maxFailPos < input.length ? input.charAt(peg$maxFailPos) : null, peg$maxFailPos < input.length
            ? peg$computeLocation(peg$maxFailPos, peg$maxFailPos + 1)
            : peg$computeLocation(peg$maxFailPos, peg$maxFailPos));
    }
}
export const parse = peg$parse;
//# sourceMappingURL=tsc-output-parser.js.map