import { APIClient } from '../api';
import type { ExecuteOptions, Execution } from '@agentuity/core';
export interface SandboxExecuteParams {
    sandboxId: string;
    options: ExecuteOptions;
    orgId?: string;
    signal?: AbortSignal;
}
/**
 * Executes a command in an existing sandbox.
 *
 * @param client - The API client to use for the request
 * @param params - Parameters including sandbox ID and execution options
 * @returns The execution result including status and stream URLs
 * @throws {SandboxResponseError} If the execution request fails
 */
export declare function sandboxExecute(client: APIClient, params: SandboxExecuteParams): Promise<Execution>;
//# sourceMappingURL=execute.d.ts.map