/**
 * CORS trusted origin helpers for same-origin configuration.
 *
 * Provides the same trusted-origin logic as @agentuity/auth,
 * allowing CORS to be restricted to platform-trusted domains.
 */
import type { Context } from 'hono';
/**
 * Options for createTrustedCorsOrigin.
 */
export interface TrustedCorsOriginOptions {
    /**
     * Additional origins to allow on top of environment-derived ones.
     * Can be full URLs (https://example.com) or bare domains (example.com).
     */
    allowedOrigins?: string[];
}
/**
 * Create a Hono CORS origin callback that only allows trusted origins.
 *
 * Trusted origins are derived from:
 * - AGENTUITY_BASE_URL environment variable
 * - AGENTUITY_CLOUD_DOMAINS environment variable (comma-separated)
 * - AUTH_TRUSTED_DOMAINS environment variable (comma-separated)
 * - The same-origin of the incoming request URL
 * - Any additional origins specified in allowedOrigins option
 *
 * @example
 * ```typescript
 * import { createApp, createTrustedCorsOrigin } from '@agentuity/runtime';
 *
 * await createApp({
 *   cors: {
 *     origin: createTrustedCorsOrigin({
 *       allowedOrigins: ['https://admin.myapp.com'],
 *     }),
 *   },
 * });
 * ```
 */
export declare function createTrustedCorsOrigin(options?: TrustedCorsOriginOptions): (origin: string, c: Context) => string | undefined;
//# sourceMappingURL=cors.d.ts.map