import type { Logger } from '@agentuity/core';
import { type APIClient } from '@agentuity/server';
import type { AuthData, Config } from '../../types';
export type IdentifierType = 'project' | 'deployment' | 'sandbox';
/**
 * Determine the type of identifier based on its prefix
 */
export declare function getIdentifierType(identifier: string): IdentifierType;
/**
 * Look up the region for a project, deployment, or sandbox identifier.
 * Uses cache-first strategy with API fallback.
 */
export declare function getIdentifierRegion(logger: Logger, auth: AuthData, apiClient: APIClient, profileName: string | undefined, identifier: string, orgId?: string, config?: Config | null): Promise<string>;
/**
 * Cache the region for a project after creation
 */
export declare function cacheProjectRegion(profileName: string | undefined, projectId: string, region: string): Promise<void>;
//# sourceMappingURL=region-lookup.d.ts.map