import { z } from 'zod';
import { APIClient } from '../api';
declare const DeleteResourcesRequest: z.ZodObject<{
    resources: z.ZodArray<z.ZodObject<{
        type: z.ZodEnum<{
            s3: "s3";
            db: "db";
        }>;
        name: z.ZodString;
    }, z.core.$strip>>;
}, z.core.$strip>;
declare const DeletedResource: z.ZodObject<{
    type: z.ZodString;
    name: z.ZodString;
    env_keys: z.ZodArray<z.ZodString>;
}, z.core.$strip>;
declare const DeleteResourcesResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodObject<{
        deleted: z.ZodArray<z.ZodObject<{
            type: z.ZodString;
            name: z.ZodString;
            env_keys: z.ZodArray<z.ZodString>;
        }, z.core.$strip>>;
    }, z.core.$strip>;
}, z.core.$strip>], "success">;
export type DeleteResourcesRequest = z.infer<typeof DeleteResourcesRequest>;
export type DeleteResourcesResponse = z.infer<typeof DeleteResourcesResponseSchema>;
export type DeletedResource = z.infer<typeof DeletedResource>;
/**
 * Delete one or more resources (DB or S3) for an organization in a specific region
 * Requires CLI authentication
 *
 * @param client - Catalyst API client
 * @param orgId - Organization ID
 * @param region - Cloud region
 * @param resources - Array of resources to delete
 * @returns
 */
export declare function deleteResources(client: APIClient, orgId: string, region: string, resources: Array<{
    type: 'db' | 's3';
    name: string;
}>): Promise<DeletedResource[]>;
export {};
//# sourceMappingURL=delete.d.ts.map