import { z } from 'zod';
import { APIClient } from '../api';
declare const ProjectListResponse: z.ZodArray<z.ZodObject<{
    id: z.ZodString;
    name: z.ZodString;
    description: z.ZodOptional<z.ZodString>;
    orgId: z.ZodString;
    orgName: z.ZodString;
    cloudRegion: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    latestDeploymentId: z.ZodNullable<z.ZodString>;
}, z.core.$strip>>;
declare const ProjectListResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodArray<z.ZodObject<{
        id: z.ZodString;
        name: z.ZodString;
        description: z.ZodOptional<z.ZodString>;
        orgId: z.ZodString;
        orgName: z.ZodString;
        cloudRegion: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        latestDeploymentId: z.ZodNullable<z.ZodString>;
    }, z.core.$strip>>;
}, z.core.$strip>], "success">;
export type ProjectListResponse = z.infer<typeof ProjectListResponseSchema>;
export type ProjectList = z.infer<typeof ProjectListResponse>;
/**
 * List all projects
 *
 * @param client
 * @param hasDeployment if true, filter by projects with at least one deployment
 * @param limit maximum number of projects to return (default: 1000, max: 10000)
 * @returns
 */
export declare function projectList(client: APIClient, hasDeployment?: boolean, limit?: number): Promise<ProjectList>;
export {};
//# sourceMappingURL=list.d.ts.map