import { z } from 'zod';
import { APIClient } from '../api';
declare const _OrgEnvUpdateRequestSchema: z.ZodObject<{
    id: z.ZodString;
    env: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
    secrets: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
}, z.core.$strip>;
type OrgEnvUpdateRequest = z.infer<typeof _OrgEnvUpdateRequestSchema>;
/**
 * Update environment variables and/or secrets for an organization.
 * This will merge the provided env/secrets with existing values.
 * Requires admin/owner role.
 * Keys starting with 'AGENTUITY_' (except AGENTUITY_PUBLIC_) are filtered out.
 */
export declare function orgEnvUpdate(client: APIClient, request: OrgEnvUpdateRequest): Promise<void>;
export {};
//# sourceMappingURL=env-update.d.ts.map