import { z } from 'zod';
import { APIClient } from '../api';
declare const EvalRunDetailSchema: z.ZodObject<{
    id: z.ZodString;
    sessionId: z.ZodString;
    evalId: z.ZodString;
    evalIdentifier: z.ZodNullable<z.ZodString>;
    evalName: z.ZodNullable<z.ZodString>;
    agentIdentifier: z.ZodNullable<z.ZodString>;
    projectId: z.ZodString;
    orgId: z.ZodString;
    deploymentId: z.ZodNullable<z.ZodString>;
    devmode: z.ZodBoolean;
    pending: z.ZodBoolean;
    success: z.ZodBoolean;
    error: z.ZodNullable<z.ZodString>;
    result: z.ZodNullable<z.ZodAny>;
    createdAt: z.ZodString;
    updatedAt: z.ZodString;
}, z.core.$strip>;
export type EvalRunDetail = z.infer<typeof EvalRunDetailSchema>;
export declare function evalRunGet(client: APIClient, id: string): Promise<EvalRunDetail>;
export {};
//# sourceMappingURL=run-get.d.ts.map