import { z } from 'zod';
import { APIClient } from '../api';
declare const QueryColumnSchema: z.ZodObject<{
    name: z.ZodString;
    type: z.ZodString;
}, z.core.$strip>;
export declare const QueryResultSchema: z.ZodObject<{
    columns: z.ZodArray<z.ZodObject<{
        name: z.ZodString;
        type: z.ZodString;
    }, z.core.$strip>>;
    rows: z.ZodArray<z.ZodRecord<z.ZodString, z.ZodAny>>;
    rowCount: z.ZodNumber;
    truncated: z.ZodBoolean;
}, z.core.$strip>;
export type QueryColumn = z.infer<typeof QueryColumnSchema>;
export type QueryResult = z.infer<typeof QueryResultSchema>;
interface DbQueryRequest {
    database: string;
    query: string;
    orgId: string;
    region: string;
}
export declare function dbQuery(client: APIClient, request: DbQueryRequest): Promise<QueryResult>;
export {};
//# sourceMappingURL=query.d.ts.map