/**
 * Minimal server globals for Vite-native architecture
 * The server is managed by Vite (dev) or Bun.serve in the generated entry file (prod)
 */
import type { Logger } from './logger';
import type { Hono, Context as HonoContext } from 'hono';
import type { Env, PrivateVariables } from './app';
import type { Tracer } from '@opentelemetry/api';
import type { SpanProcessor } from '@opentelemetry/sdk-trace-base';
/**
 * List of AgentContext properties that should trigger helpful error messages
 * when accessed directly on HonoContext in route handlers.
 */
export declare const AGENT_CONTEXT_PROPERTIES: readonly ["logger", "tracer", "sessionId", "kv", "stream", "vector", "sandbox", "queue", "state", "thread", "session", "config", "app"];
export declare function getRouter(): Hono<Env<any>, import("hono/types").BlankSchema, "/"> | null;
export declare function setGlobalRouter(router: Hono<Env<any>>): void;
/**
 * Returns the global logger instance.
 * This is a singleton created during application initialization.
 */
export declare function createLogger(): Logger | null;
export declare function getLogger(): Logger | null;
export declare function setGlobalLogger(logger: Logger): void;
export declare function getTracer(): Tracer | null;
export declare function setGlobalTracer(tracer: Tracer): void;
/**
 * Add a custom span processor that will be added to the otel configuration.
 * This method must be called before the server is initialized.
 */
export declare function addSpanProcessor(processor: SpanProcessor): void;
export declare function getSpanProcessors(): SpanProcessor[];
/**
 * Helper to cast HonoContext to include private variables
 */
export declare function privateContext<E extends Env>(c: HonoContext<E>): HonoContext<{
    Variables: PrivateVariables;
}>;
/**
 * No-op for Vite-native architecture (Vite manages server lifecycle)
 */
export declare const notifyReady: () => void;
/**
 * No-op for Vite-native architecture (returns null)
 */
export declare function getServer(): null;
//# sourceMappingURL=_server.d.ts.map