import { type ExportResult } from '@opentelemetry/core';
import type { LogRecordExporter, ReadableLogRecord } from '@opentelemetry/sdk-logs';
import type { SpanExporter, ReadableSpan } from '@opentelemetry/sdk-trace-base';
/**
 * Console implementation of the LogRecordExporter interface
 * Uses __originalConsole to avoid infinite loop when console is patched
 */
export declare class ConsoleLogRecordExporter implements LogRecordExporter {
    private dumpRecords;
    constructor(dumpRecords: boolean);
    /**
     * Exports log records to the console
     *
     * @param logs - The log records to export
     * @param resultCallback - Callback function to report the export result
     */
    export(logs: ReadableLogRecord[], resultCallback: (result: ExportResult) => void): void;
    /**
     * Shuts down the exporter
     *
     * @returns A promise that resolves when shutdown is complete
     */
    shutdown(): Promise<void>;
}
/**
 * Console implementation of the SpanExporter interface
 * Uses __originalConsole to avoid infinite loop when console is patched
 */
export declare class DebugSpanExporter implements SpanExporter {
    export(spans: ReadableSpan[], resultCallback: (result: ExportResult) => void): void;
    shutdown(): Promise<void>;
}
//# sourceMappingURL=console.d.ts.map