/**
 * Bun S3 monkey-patch for Agentuity storage endpoints
 *
 * Agentuity storage uses virtual-hosted-style URLs (e.g., ag-{id}.t3.storage.dev).
 * Bun's default s3 export uses path-style addressing, causing bucket path mismatch.
 *
 * This module patches Bun.S3Client.prototype methods to automatically set
 * virtualHostedStyle: true when S3_ENDPOINT matches *.storage.dev
 *
 * Patched methods:
 * - file(path, options?) - S3Options
 * - presign(path, options?) - S3FilePresignOptions
 * - write(path, data, options?) - S3Options
 * - delete(path, options?) - S3Options
 * - exists(path, options?) - S3Options
 * - stat(path, options?) - S3Options
 * - size(path, options?) - S3Options
 * - unlink(path, options?) - S3Options
 * - list(input?, options?) - options type doesn't include virtualHostedStyle but we inject it anyway
 */
/**
 * Check if an endpoint is an Agentuity storage endpoint (*.storage.dev)
 */
export declare function isAgentuityStorageEndpoint(raw: string): boolean;
/**
 * Patch Bun's S3Client to automatically use virtualHostedStyle for storage.dev endpoints
 *
 * This function:
 * 1. Checks if we're running in Bun with S3 support
 * 2. Checks if S3_ENDPOINT (or AWS_ENDPOINT) points to *.storage.dev
 * 3. Patches S3Client.prototype methods to inject virtualHostedStyle: true
 *
 * Safe to call in non-Bun environments (will no-op).
 * Idempotent (safe to call multiple times).
 */
export declare function patchBunS3ForStorageDev(): void;
//# sourceMappingURL=bun-s3-patch.d.ts.map