import { z } from 'zod';
import type { ToolContext } from '@opencode-ai/plugin';
import type { BackgroundManager } from '../background';
export declare const BackgroundTaskArgsSchema: z.ZodObject<{
    agent: z.ZodEnum<{
        lead: "lead";
        scout: "scout";
        builder: "builder";
        architect: "architect";
        reviewer: "reviewer";
        memory: "memory";
        expert: "expert";
        planner: "planner";
        runner: "runner";
        reasoner: "reasoner";
        product: "product";
    }>;
    task: z.ZodString;
    description: z.ZodOptional<z.ZodString>;
}, z.core.$strip>;
export declare const BackgroundOutputArgsSchema: z.ZodObject<{
    task_id: z.ZodString;
}, z.core.$strip>;
export declare const BackgroundCancelArgsSchema: z.ZodObject<{
    task_id: z.ZodString;
}, z.core.$strip>;
export type BackgroundTaskArgs = z.infer<typeof BackgroundTaskArgsSchema>;
export type BackgroundOutputArgs = z.infer<typeof BackgroundOutputArgsSchema>;
export type BackgroundCancelArgs = z.infer<typeof BackgroundCancelArgsSchema>;
export declare function createBackgroundTools(manager: BackgroundManager): {
    backgroundTaskTool: {
        name: string;
        description: string;
        args: typeof BackgroundTaskArgsSchema;
        execute: (args: BackgroundTaskArgs, context: ToolContext) => Promise<{
            taskId: string;
            status: string;
            message: string;
        }>;
    };
    backgroundOutputTool: {
        name: string;
        description: string;
        args: typeof BackgroundOutputArgsSchema;
        execute: (args: BackgroundOutputArgs) => Promise<{
            taskId: string;
            status: string;
            result?: string;
            error?: string;
        }>;
    };
    backgroundCancelTool: {
        name: string;
        description: string;
        args: typeof BackgroundCancelArgsSchema;
        execute: (args: BackgroundCancelArgs) => Promise<{
            taskId: string;
            success: boolean;
            message: string;
        }>;
    };
};
//# sourceMappingURL=background.d.ts.map